# -*- coding: utf-8 -*-
"""
@author: tobias.bosse@de.bosch.com
"""
import configparser
import os
import threading
from pprint import pprint
import uuid
import time

##Openapi Integration
import openapi_client_strategy
import openapi_client_ai
import openapi_client_sim

# import openapi_client_dataservice

# Configure the Server
import connexion
from openapi_server_sim import encoder

# Read API keys and ports from the .ini file
config = configparser.ConfigParser()
config.read(os.path.join(os.path.dirname(__file__), "api_config.ini"))

# Configure the clients
# Strategy
strategy_configuration = openapi_client_strategy.Configuration(
    host=f"http://127.0.0.1:{config.get('PORTS', 'strategy_port')}/aissi/strategy/adapter/api/v1"
)
strategy_configuration.api_key["ApiKeyAuth"] = config.get("API_KEYS", "strategy_key")

# AI
ai_configuration = openapi_client_ai.Configuration(
    host=f"http://127.0.0.1:{config.get('PORTS', 'ai_port')}/aissi/ai/adapter/api/v1"
)
ai_configuration.api_key["ApiKeyAuth"] = config.get("API_KEYS", "ai_key")

# Sim
sim_configuration = openapi_client_sim.Configuration(
    host=f"http://127.0.0.1:{config.get('PORTS', 'sim_port')}/aissi/simulation/adapter/api/v1"
)
sim_configuration.api_key["ApiKeyAuth"] = config.get("API_KEYS", "sim_key")

# Dataservice
# data_configuration = openapi_client_dataservice.Configuration(
#    host=f"http://127.0.0.1:{config.get('PORTS', 'dataservice_port')}/aissi/dataservice/adapter/api/v1"
# )
# data_configuration.api_key["ApiKeyAuth"] = config.get("API_KEYS", "data_key")


def run_server():
    app = connexion.App(
        __name__, specification_dir="./Generator/server_sim/openapi_server_sim/openapi/"
    )
    app.app.json_encoder = encoder.JSONEncoder
    app.add_api(
        "openapi.yaml",
        arguments={"title": "AISSI Platform Simulation Adapter Service API"},
        pythonic_params=True,
    )
    app.run(port=config.get("PORTS", "sim_port"))


def sendIndex(env_index):
    from openapi_client_strategy import ApiException

    response_strategy_create_environment_message = (
        openapi_client_strategy.ResponseStrategyCreateEnvironmentMessage(
            environmentId=str(env_index)
        )
    )
    with openapi_client_strategy.ApiClient(strategy_configuration) as api_client:
        api_instance = openapi_client_strategy.StrategyResponseApi(api_client)
        try:
            api_response = api_instance.response_create_environment(
                response_strategy_create_environment_message
            )
            pprint(api_response)
        except ApiException as e:
            print(
                "Exception when calling response_strategy_create_environment_message->response_get_new_environment: %s\n"
                % e
            )


def actionbyAgent(agent_id, State):
    from openapi_client_ai.rest import ApiException

    request_ai_optimal_action_message = (
        openapi_client_ai.RequestAIComputeOptimalActionMessage(
            ai_model_id=agent_id,
            state=State,
        )
    )
    with openapi_client_ai.ApiClient(ai_configuration) as api_client:
        api_instance = openapi_client_ai.AIRequestApi(api_client)
        try:
            api_response = api_instance.request_compute_optimal_action(
                request_ai_optimal_action_message
            )
            pprint(api_response)
        except ApiException as e:
            print(
                "Exception when calling AIRequestApi->request_compute_action: %s\n" % e
            )


def SendKPIs(env_id):
    from openapi_client_strategy.rest import ApiException

    response_strategy_kpi_message = openapi_client_strategy.ResponseStrategyRunRolloutMessage(  # response_strategy_run_rollout_message
        environment_id=env_id
    )
    with openapi_client_strategy.ApiClient(strategy_configuration) as api_client:
        api_instance = openapi_client_strategy.StrategyResponseApi(api_client)
        try:
            api_response = api_instance.response_run_rollout(
                response_strategy_kpi_message
            )
            pprint(api_response)
        except ApiException as e:
            print(
                "Exception when calling StrategyResponseApi->response_get_kpi: %s\n" % e
            )


intervalls = 0


def dummy_run(env_id, agent_id):
    print("dummy run envirnoment id: ", env_id)
    intervall_mins = 60
    complete_simulation_mins = (
        48
    ) * 60  # Environment Model is only defined for a specific time
    global intervalls
    intervalls += 1
    current_time = intervalls * intervall_mins
    state = openapi_client_ai.State(
        wip=[openapi_client_ai.Wip(enter_operation_time="2021-01-01T00:00:00Z")],
        current_date_time="2021-01-01T00:00:00Z",
        environment_id=env_id,
    )

    time.sleep(0.25)
    if current_time < complete_simulation_mins:
        actionbyAgent(agent_id, state)
    else:
        SendKPIs(env_id)
        print("Done!")


# Overriding of Server functions
from openapi_server_sim.models.request_simulation_create_environment_message import (
    RequestSimulationCreateEnvironmentMessage,
)
from openapi_server_sim.models.request_simulation_run_rollout_message import (
    RequestSimulationRunRolloutMessage,
)
from openapi_server_sim.models.response_simulation_compute_optimal_action_message import (
    ResponseSimulationComputeOptimalActionMessage,
)

# from openapi_server_sim.models.response_simulation_run_rollout_message import (
#    ResponseSimulationRunRolloutMessage,
# )


def edited_response_optimal_action(body):
    if connexion.request.is_json:
        response_simulation_action_message = (
            ResponseSimulationComputeOptimalActionMessage.from_dict(
                connexion.request.get_json()
            )
        )  # noqa: E501
    dispatch_actions = response_simulation_action_message.dispatch_action
    env_id = dispatch_actions.environment_id
    global agent_id
    agent_id = agent_id

    threading.Thread(
        target=dummy_run,
        args=(
            env_id,
            agent_id,
        ),
        daemon=True,
    ).start()
    # Put your code here

    return "Ok, Continue Simulation!"


from openapi_server_sim.controllers import simulation_response_controller

simulation_response_controller.response_compute_optimal_action = (
    edited_response_optimal_action
)


def edited_request_create_environment(body):
    """Create a training environment

    Create a new training environment. Receives request id and training environment configuration. Returns the request id, the training environment id, and the training environment state. # noqa: E501

    :param request_simulation_create_environment_message: Create a new training environment.
    :type request_simulation_create_environment_message: dict | bytes

    :rtype: Union[str, Tuple[str, int], Tuple[str, int, Dict[str, str]]
    """
    if connexion.request.is_json:
        request_simulation_create_environment_message = (
            RequestSimulationCreateEnvironmentMessage.from_dict(
                connexion.request.get_json()
            )
        )  # noqa: E501

    # Put your code here
    env_id = uuid.uuid4()
    print(f"Dummy Scenario created with ID {env_id}")
    sendIndex(env_id)

    return "Ok, create Simumlation"


from openapi_server_sim.controllers import simulation_management_request_controller

simulation_management_request_controller.request_create_environment = (
    edited_request_create_environment
)


def edited_request_roll_out(body):
    """Create a training environment

    Create a new training environment. Receives request id and training environment configuration. Returns the request id, the training environment id, and the training environment state. # noqa: E501

    :param request_simulation_create_environment_message: Create a new training environment.
    :type request_simulation_create_environment_message: dict | bytes

    :rtype: Union[str, Tuple[str, int], Tuple[str, int, Dict[str, str]]
    """
    if connexion.request.is_json:
        request_simulation_rollout_message = (
            RequestSimulationRunRolloutMessage.from_dict(connexion.request.get_json())
        )  # noqa: E501
    global agent_id
    agent_id = request_simulation_rollout_message.ai_model_id
    env_id = request_simulation_rollout_message.environment_id
    # print(agent_id)
    # print(env_id)

    threading.Thread(
        target=dummy_run,
        args=(
            env_id,
            agent_id,
        ),
        daemon=True,
    ).start()
    # Put your code here

    return "Ok, Simulation is running!"


from openapi_server_sim.controllers import simulation_request_controller

simulation_request_controller.request_run_rollout = edited_request_roll_out


if __name__ == "__main__":
    run_server()
